package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import org.w3c.dom.Document;


public class AssetAssignPostSave  extends ValidatorEJB {
	  ActionHandlerEJB actionHandlerEJB = new ActionHandlerEJB();
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String postSave() throws RemoteException, ITMException {
		return "";
	}
	
	public String postSave(String domString, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
	    System.out.println("Inside the post save ... ");
		PreparedStatement pstmt = null;
		Document dom = null;                
		ResultSet rs =null;
		String tranId = "";
		String assetCode = "";
		String erroString="";
		double cnt=0;
		boolean isError = false;


		String sql = null;

	    
	    try
		{
			ITMDBAccessEJB	itmDBAccessEJB = new ITMDBAccessEJB();
			E12GenericUtility genericUtility = new E12GenericUtility();
			dom = genericUtility.parseString(domString);
			
			

			tranId = genericUtility.getColumnValue("tran_id", dom).trim();
			assetCode=genericUtility.getColumnValue("asset_code",dom);

			

			sql="update asset_register set TRAN_ID__ASSIGN=? where asset_code=? " ;//end

			pstmt = conn.prepareStatement(sql);
		
			pstmt.setString(1,tranId );
			pstmt.setString(2,assetCode );
			
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

		}
			catch(Exception e)
			{
				try {
					conn.rollback();
				} catch (SQLException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				isError = true;
				BaseLogger.log("3", getUserInfo(), null, "Exception :DcdetPostSaveEJB : :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
	    finally
		{
			try
			{
				BaseLogger.log("3", getUserInfo(), null, "isError ["+isError+"]");
				if( conn != null )
				{

				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				BaseLogger.log("3", getUserInfo(), null, "Exception :SavexPreSaveEJB : :==>\n"+e.getMessage());
				try
				{
					BaseLogger.log("3", getUserInfo(), null, "Before rollback");
					conn.rollback();
				}

				catch(SQLException sqle)
				{
					BaseLogger.log("3", getUserInfo(), null, sqle);
				}
				throw new ITMException(e);
			}
		}
			

	    return erroString;
	}
	
	
	private String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}


}
